var heightArray = [];
var smallScreen = 720;
var mqMatch;
var i = 1;

function mobileWidth(screenWidth) {

	console.log(screenWidth);
	if (screenWidth <= smallScreen) {

		mqMatch = false;

	} else {

		mqMatch = true;

	}
}

function findHeight(el, desktop) {

    el.height('auto').each(function() {

    	if (desktop) {

        	heightArray.push(el.height());

        } else {

        	el.attr("data-height", el.height());

        }

    }).height('0');

}

(function( $ ){
   $.fn.transitionHeight = function() {
	    var $this = $(this);

	    console.log($this);

	    if (!$this.hasClass('hideHeight')) {

	    	console.log('open');
	    	$this.addClass('hideHeight').height($this.attr('data-height'));
	    	return true;

	    } else {

	    	console.log('close');
	    	$this.removeClass('hideHeight').height(0);
	    	return true;

	    }
	};
})(jQuery);

function desktopNav() {

	var largestHeight = Math.max.apply(Math, heightArray) + 12;

	$('.subNav, #subBkgd').attr('data-height', largestHeight);
	$('#mainNav .subNav').removeClass('hideHeight');

	$('#mainNav').bind({

		mouseenter: function () {
			var $this = $(this);

			$this.css('padding-bottom', largestHeight);
			$('.subNav, #subBkgd', $this).transitionHeight();

		},

		mouseleave: function () {
			var $this = $(this);

			$this.css('padding-bottom', '8px');
			$('.subNav, #subBkgd', $this).transitionHeight();

		}
	});
}

function mobileNav() {

	$('#mainNav li').removeClass('open');

	$('.dropDownItem').click(function () {
		var $this = $(this);
		var $listItem = $this.parent('li');
		var $eachListItem = $listItem.siblings();
		var $eachDropList = $eachListItem.children('ul');
		var $dropList = $this.next('ul');

		if ($listItem.hasClass('open')) {

			$listItem.removeClass('open');
			$dropList.transitionHeight();

		} else {

			$eachListItem.removeClass('open');
			$eachDropList.removeClass('hideHeight').height(0);

			$listItem.addClass('open');
			$dropList.transitionHeight();

		}
	});
}

function isDesktop(desktop) {

	if (desktop) {

		$('.subNav, #subBkgd').each(function () {
			var $this = $(this);

			findHeight($this, desktop);

		});

	} else {

		$('.subNav').each(function () {
			var $this = $(this);

			findHeight($this, desktop);

		});

	}
}

$(document).ready(function () {
	var screenWidth = $(window).width();

	mobileWidth(screenWidth);
	
	if(mqMatch) {
		//Desktop Nav Funtions
		isDesktop(mqMatch);
		desktopNav();

	} else {
		//Mobile Nav Functions
		isDesktop(mqMatch);
		mobileNav();
	}

	// Mob Nav open button 
	$('#openMenu').click(function () {

		$this = $(this);

		if($this.hasClass('menuOpen')) {

			$this.removeClass('menuOpen');
			$('#mainNav').removeClass('openedMenu');
			$('header section, #central').removeClass('expanded');

		} else {

			$this.addClass('menuOpen');
			$('#mainNav').addClass('openedMenu');
			$('header section, #central').addClass('expanded');

		}

	});

	$(window).resize(function () {
		var screenWidth = $(window).width();

		mobileWidth(screenWidth);

		if(mqMatch) {

			//Desktop Nav Funtions
			heightArray = [];
			isDesktop(mqMatch);
		 	desktopNav();

		} else {

		 	//Mobile Nav Functions
		 	isDesktop(mqMatch);
			$('#mainNav').unbind('mouseenter mouseleave');
		 	mobileNav();

		}

	});
});

