if('CSS' in window && 'supports' in window.CSS) {
    var support = window.CSS.supports('mix-blend-mode','multiply');
    support = support?'mix-blend-mode':'no-mix-blend-mode';
    $('html').addClass(support);
}

var smallScreen = 960;
var $mainMenu = $('.mainNav');

function windowSize () {

    if ($(window).width() >= smallScreen) {

        $mainMenu.css({
            opacity: 1,
            zIndex: 'auto'
        });

    } else {

        if ($('#openMenu').hasClass('menuOpen')) {

            $mainMenu.css({
                zIndex: 10,
                opacity: 1
            });

        } else {

            $mainMenu.css({
                zIndex: '-1',
                opacity: 0
            });

        }
    }
}

function guestListHeight() {
    var $testimonialsList = $('#guestbook');
    var listItemArray = [];

    $('li', $testimonialsList).each(function () {
        listItemArray.push($(this).height());
    });

    $testimonialsList.height(Math.max.apply( Math, listItemArray ));

}

$(document).ready(function () {

    windowSize();

    // Mob Nav open button
    $('#openMenu').click(function () {

        var $this = $(this);

        if($this.hasClass('menuOpen')) {

            $this.removeClass('menuOpen');
            $mainMenu.css('opacity', 0);

            setTimeout(function () {

                $mainMenu.css('z-index', '-1');

            }, 510);

        } else {

            $this.addClass('menuOpen');
            $mainMenu.css({
                zIndex: 10,
                opacity: 1
            });

        }

    });



    if (!$('body').hasClass('editing')) {

        guestListHeight();

        $('#guestbook').cycle({
            fx:    'fade',
            speed:  2500,
            next:   '#next',
            prev:   '#prev'
        });

    }

    $(window).resize(function () {
        windowSize();
        guestListHeight();
    });

});